// ======== ======== ======== ======== ======== ======== ======== ========
//
//			[Wwise.cpp] 						Auter : KENSUKE WATANABE
//												Data  : 2017/09/06
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2017/09/06
//
// ======== ======== ======== ======== ======== ======== ======== ========
#include "main.h"
#include "Wwise.h"

// }l[WɕKv
#include <AK/SoundEngine/Common/AkMemoryMgr.h>				// }l[W
#include <AK/SoundEngine/Common/AkModule.h>					// ftHg, Xg[}l[W

// Xg[~OĐɕKv
#include <AK/SoundEngine/Common/IAkStreamMgr.h>				// Xg[}l[W
#include <AK/Tools/Common/AkPlatformFuncs.h>				// Xbh
#include "Wwise_Win32/AkFilePackageLowLevelIOBlocking.h"	// ჌xI/O

// ~[WbNGWɕKv
#include <AK/MusicEngine/Common/AkMusicEngine.h>			// ~[WbNGW

// WwiseƃQ[̊Ԃ̒ʐMɕKv - [Xo[Wł͕sv
#ifndef AK_OPTIMIZED
#include <AK/Comm/AkCommunication.h>
#endif // AK_OPTIMIZED

// ======== ======== ======== ======== ======== ======== ======== ========
//	tbN
// -------- -------- -------- -------- -------- -------- -------- --------
// JX^alloc/free֐B
// AkMemoryMgr.h "extern"ƂĐ錾Ă
// -------- -------- -------- -------- -------- -------- -------- --------
namespace AK
{
#ifdef WIN32
	void *AllocHook(size_t in_size) { return malloc(in_size); }

	void FreeHook(void *in_ptr) { free(in_ptr); }

	void *VirtualAllocHook(void * in_pMemAddress, size_t in_size, DWORD in_dwAllocationType, DWORD in_dwProtect)
	{
		return VirtualAlloc(in_pMemAddress, in_size, in_dwAllocationType, in_dwProtect);
	}

	void VirtualFreeHook(void *in_pMemAddress, size_t in_size, DWORD in_dwFreeType)
	{
		VirtualFree(in_pMemAddress, in_size, in_dwFreeType);
	}
#endif
}

#ifdef AK_MOTION
#include <AK/MotionEngine/Common/AkMotionEngine.h>	// Motion Engine (required only for playback of Motion objects)
#endif

static const AkGameObjectID LISTENER_ID = 10001;

// #include <AK/Plugin/AllPluginsRegistrationHelpers.h>

// ======== ======== ======== ======== ======== ======== ======== ========
// Oȗ
using namespace std;

// ======== ======== ======== ======== ======== ======== ======== ========
// }N
#define CHECK_SOUND_ENGINE if( !SoundEngine::IsInitialized() ) return;
#define CHECK_SOUND_ENGINE0 if( !SoundEngine::IsInitialized() ) return 0;
#define CHECK_NULLPTR(p) { if(p == nullptr) return; }

// ======== ======== ======== ======== ======== ======== ======== ========
// ÓIo
CAkFilePackageLowLevelIOBlocking CWwise::m_lowLevelIO;
std::list<int> CWwise::dummies;
CAkLock CWwise::dummiesLock;

// ======== ======== ======== ======== ======== ======== ======== ========
// 
void CWwise::Init()
{
	// -------- -------- -------- --------
	// }l[W
	//
	AkMemSettings memSettings;
	memSettings.uMaxNumPools = 20;

	if (MemoryMgr::Init(&memSettings) != AK_Success)
	{
		AKASSERT(!"Could not create the memory manager.");
		return;
	}

	// -------- -------- -------- --------
	// Xg[~O}l[W
	//
	AkStreamMgrSettings stmSettings;
	AK::StreamMgr::GetDefaultSettings(stmSettings);

	if (!StreamMgr::Create(stmSettings))
	{
		AKASSERT(!"Could not create the Stream Manager");
		return;
	}

	// -------- -------- -------- --------
	// Xg[~OfoCX
	//
	AkDeviceSettings deviceSettings;
	AK::StreamMgr::GetDefaultDeviceSettings(deviceSettings);

	if (m_lowLevelIO.Init(deviceSettings) != AK_Success)
	{
		AKASSERT(!"Could not create the streaming device and Low-Level I/O system");
		return;
	}

	// -------- -------- -------- --------
	// TEhGW
	//
	AkInitSettings initSettings;
	AkPlatformInitSettings platformInitSettings;
	AK::SoundEngine::GetDefaultInitSettings(initSettings);
	AK::SoundEngine::GetDefaultPlatformInitSettings(platformInitSettings);

	// Setting pool sizes for this game. Here, allow for user content; every game should determine its own optimal values.
	initSettings.uDefaultPoolSize = 2 * 1024 * 1024;
	platformInitSettings.uLEngineDefaultPoolSize = 4 * 1024 * 1024;

	if (AK::SoundEngine::Init(&initSettings, &platformInitSettings) != AK_Success)
	{
		assert(!"Could not initialize the Sound Engine.");
		return;
	}

	// -------- -------- -------- --------
	// ~[WbNGW
	//
	AkMusicSettings musicInit;
	AK::MusicEngine::GetDefaultInitSettings(musicInit);

	if (AK::MusicEngine::Init(&musicInit) != AK_Success)
	{
		assert(!"Could not initialize the Music Engine.");
		return;
	}

	/*
	// -------- -------- -------- --------
	// vOC
	//
	/// Note: This a convenience method for rapid prototyping. 
	/// To reduce executable code size register/link only the plug-ins required by your game 
	if (AK::SoundEngine::RegisterAllPlugins() != AK_Success)
	{
		AKASSERT(!"Error while registering plug-ins");
		return;
	}
	*/

	// -------- -------- -------- --------
	// ʐM̏
	//
#ifndef AK_OPTIMIZED
	AkCommSettings commSettings;
	AK::Comm::GetDefaultInitSettings(commSettings);
	if (AK::Comm::Init(commSettings) != AK_Success)
	{
		assert(!"Could not initialize communication.");
		return;
	}
#endif // AK_OPTIMIZED

	// -------- -------- -------- --------
	// ჌xI/O
	//
	// oNXNvg̃pX
	m_lowLevelIO.SetBasePath(AKTEXT("data/wwisePrj_InitialT/GeneratedSoundBanks/Windows/"));

	// Q[݂̌̌̎w
	AK::StreamMgr::SetCurrentLanguage(AKTEXT("English(US)"));

	// -------- -------- -------- --------
	// oN̓ǂݍ
	//
	AkBankID bankID;
	AKRESULT retValue;

	// oN
	retValue = SoundEngine::LoadBank("Init.bnk", AK_DEFAULT_POOL_ID, bankID);
	assert(retValue == AK_Success);

	// CoN
	retValue = SoundEngine::LoadBank("main.bnk", AK_DEFAULT_POOL_ID, bankID);
	assert(retValue == AK_Success);

	/*
	// {[̏
	musicvol(255);
	soundvol(255);
	voicevol(255);
	*/

	/*
	// Wwise[V
#ifdef AK_MOTION
	MotionEngine::AddPlayerMotionDevice(0, AKCOMPANYID_AUDIOKINETIC, AKMOTIONDEVICEID_RUMBLE, nullptr);
	MotionEngine::SetPlayerListener(0, 0);
	SoundEngine::SetListenerPipeline(0, true, true);
#endif
	*/

	// CXi[̐ݒ
	m_pMainListener = CWwise::CreateGameObj(D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), "MainListener");	// Q[IuWFNgƂēo^
}

// ======== ======== ======== ======== ======== ======== ======== ========
// I
void CWwise::Uninit()
{
	// Q[IuWFNg̏
	for (auto gameObject : m_umapGameObj)
	{
		if (gameObject.second != nullptr)
		{
			CWwise::unregistPtr(gameObject.second);	// Q[IuWFNg̓o^
			delete gameObject.second;
			gameObject.second = nullptr;
		}
	}
	m_umapGameObj.clear();

	// ʐM
#ifndef AK_OPTIMIZED
	Comm::Term();
#endif // AK_OPTIMIZED

	// ~[WbNGW
	MusicEngine::Term();

	// TEhGW
	SoundEngine::Term();

	// ჌xo
	m_lowLevelIO.Term();
	if (IAkStreamMgr::Get())
		IAkStreamMgr::Get()->Destroy();

	// }l[W
	MemoryMgr::Term();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// XV
void CWwise::Update()
{
	CHECK_SOUND_ENGINE;

	// ======== ======== ======== ========
	// Xi[̐ݒ
	AkSoundPosition MainListener;

	float fRadPitch = m_pMainListener->rot.z;
	float fCosPitch = cos(fRadPitch);
	float fSinPitch = sin(fRadPitch);

	float fRadYaw = m_pMainListener->rot.y - D3DX_PI * 0.5f;
	float fCosYaw = cos(fRadYaw);
	float fSinYaw = sin(fRadYaw);

	// OxNg
	AkVector front;
	front.X = fCosYaw * fCosPitch;
	front.Y = fSinYaw * fCosPitch;
	front.Z = fSinPitch;

	// xNg
	AkVector top;
	top.X = -fCosYaw * fSinPitch;
	top.Y = -fSinYaw * fSinPitch;
	top.Z = fCosPitch;

	// OAxNg̐ݒ
	MainListener.SetOrientation(front, top);

	// Wݒ
	AkVector position;
	VecToAkVector(m_pMainListener->pos, position);
	MainListener.SetPosition(position);

	// Xi[̐ݒ
	SoundEngine::SetPosition(LISTENER_ID, MainListener);

	// ======== ======== ======== ========
	// eQ[IuWFNg̐ݒ
	AkSoundPosition soundPos;
	for (auto gameObject : m_umapGameObj)
	{
		fRadPitch = gameObject.second->rot.z;
		fCosPitch = cos(fRadPitch);
		fRadYaw = gameObject.second->rot.y - D3DX_PI * 0.5f;

		// OxNg
		front.X = (float)(cos(fRadYaw) * fCosPitch);
		front.Y = (float)(sin(fRadYaw) * fCosPitch);
		front.Z = (float)(sin(fRadPitch));

		// xNg
		top = { 0, 1.f, 0 };
		soundPos.SetOrientation(front, top);

		// Wݒ
		VecToAkVector(gameObject.second->pos, position);
		soundPos.SetPosition(position);

		// Q[IuWFNg̐ݒ
		SoundEngine::SetPosition((AkGameObjectID)gameObject.second, soundPos);
	}

	// ݒ肳ꂽCxg̎s
	SoundEngine::RenderAudio();
};

// ======== ======== ======== ======== ======== ======== ======== ========
// Q[IuWFNgo^
WWISE_GAMEOBJ *CWwise::CreateGameObj(D3DXVECTOR3 pos, D3DXVECTOR3 rot, char *pName)
{
	WWISE_GAMEOBJ *pGameObject = new WWISE_GAMEOBJ;
	pGameObject->pos = pos;							// W
	pGameObject->rot = rot;							// px
	pGameObject->vel = D3DXVECTOR3(0.f, 0.f, 0.f);	// x(hbv[p)
	
	// GW֓o^
	CWwise::registPtr(pGameObject, pName);

	// Xg֒ǉ
	if (m_umapGameObj.count(pName) >= 1)
	{
		delete m_umapGameObj[pName];
		m_umapGameObj[pName] = nullptr;
	}
	m_umapGameObj[pName] = pGameObject;
	AK::SoundEngine::RegisterGameObj(LISTENER_ID, "Listener (Default)");
	AK::SoundEngine::SetDefaultListeners(&LISTENER_ID, 1);

	return pGameObject;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// Xi[Q[IuWFNgo^
WWISE_GAMEOBJ *CWwise::CreateNoListenerGameObj(D3DXVECTOR3 pos, D3DXVECTOR3 rot, char *pName)
{
	WWISE_GAMEOBJ *pGameObject = new WWISE_GAMEOBJ;
	pGameObject->pos = pos;							// W
	pGameObject->rot = rot;							// px
	pGameObject->vel = D3DXVECTOR3(0.f, 0.f, 0.f);	// x(hbv[p)

	// GW֓o^
	CWwise::registPtr(pGameObject, pName);

	// Xg֒ǉ
	if (m_umapGameObj.count(pName) >= 1)
	{
		delete m_umapGameObj[pName];
		m_umapGameObj[pName] = nullptr;
	}
	m_umapGameObj[pName] = pGameObject;

	return pGameObject;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// Q[IuWFNg̏
void CWwise::DeleteGameObj(std::string gameObjectName)
{
	CHECK_SOUND_ENGINE;
	if (m_umapGameObj.count(gameObjectName) == 0) { return; }

	// wQ[IuWFNg̏
	CWwise::unregistPtr(m_umapGameObj[gameObjectName]);
	delete m_umapGameObj[gameObjectName];
	m_umapGameObj[gameObjectName] = nullptr;
	m_umapGameObj.erase(gameObjectName);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// Q[IuWFNg̓o^(GWɓo^)
void CWwise::registPtr(void *gameObject, char *pName)
{
	CHECK_SOUND_ENGINE;

	if (pName == nullptr)
	{
		static int cEntity = 0;
		char name[256];
		sprintf(name, "Entity #%i", (int) ++cEntity);

		SoundEngine::RegisterGameObj((AkGameObjectID)gameObject, name);
	}
	else
	{
		SoundEngine::RegisterGameObj((AkGameObjectID)gameObject, pName);
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// Q[IuWFNg̏(GW폜)
void CWwise::unregistPtr(void *gameObject)
{
	CHECK_SOUND_ENGINE;

	SoundEngine::UnregisterGameObj((AkGameObjectID)gameObject);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// Cxg̐ݒ
// 
// -------- -------- -------- -------- -------- -------- -------- --------
// CXi[ɃCxg𑗐M
void CWwise::MainListenerGameObjEvent(int eventID)
{
	CHECK_SOUND_ENGINE;

	SoundEngine::PostEvent(eventID, (AkGameObjectID)m_pMainListener);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// ID, [hW ([hWݒ̏ꍇ͎IɃvC[ւ̃CxgݒƂȂ)
void CWwise::SetEvent(int eventID, D3DXVECTOR3 *loc)
{
	CHECK_SOUND_ENGINE;

	if (loc == nullptr)
		SoundEngine::PostEvent(eventID, (AkGameObjectID)m_pMainListener);
	else
	{
		// _~[gp
		dummiesLock.Lock();			// bN
		dummies.push_back(0);			// _~[o^
		int &dummy = dummies.back();	// 擾
		dummiesLock.Unlock();			// AbN

		// _~[Cxg֓o^
		SoundEngine::RegisterGameObj((AkGameObjectID)&dummy, "PlayAtLocation");

		// _~[̎pƍWݒ
		AkVector front = { 0, 0, 1.f };
		AkVector top = { 0, 1.f, 0 };
		AkVector position;
		VecToAkVector(*loc, position);

		// W_~[ɓo^
		AkSoundPosition soundPos;
		soundPos.Set(position, front, top);
		SoundEngine::SetPosition((AkGameObjectID)&dummy, soundPos);

		// Cxg̑M
		AkPlayingID id = SoundEngine::PostEvent(eventID, (AkGameObjectID)&dummy, AK_EndOfEvent, dummyCallback);
		if (id != AK_INVALID_PLAYING_ID)
		{
			// IDłȂΓo^
			dummy = id;
		}
		else
		{
			// IDł΁ARei_~[o
			SoundEngine::UnregisterGameObj((AkGameObjectID)&dummy);
			dummiesLock.Lock();		// bN
			dummies.pop_back();			// o
			dummiesLock.Unlock();		// AbN
		}
	}
};

// ======== ======== ======== ======== ======== ======== ======== ========
// Cxg, [hW
void CWwise::SetEvent(char *pName, D3DXVECTOR3 *loc)
{
	CHECK_SOUND_ENGINE;

	AkUniqueID eventID = SoundEngine::GetIDFromString(pName);
	if (eventID != AK_INVALID_UNIQUE_ID)
	{
		CWwise::SetEvent((int)eventID, loc);
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// ID, Q[IuWFNg
void CWwise::SetEvent(int eventID, std::string GameObjectName)
{
	CHECK_SOUND_ENGINE;
	if (m_umapGameObj.count(GameObjectName) == 0) { return; }

	SoundEngine::PostEvent(eventID, (AkGameObjectID)m_umapGameObj[GameObjectName]);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// Cxg, Q[IuWFNg
void CWwise::SetEvent(char *pName, std::string GameObjectName)
{
	CHECK_SOUND_ENGINE;
	if (m_umapGameObj.count(GameObjectName) == 0) { return; }

	SoundEngine::PostEvent(pName, (AkGameObjectID)m_umapGameObj[GameObjectName]);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// ĐCxg̒~
void CWwise::Stop(std::string name)
{
	CHECK_SOUND_ENGINE;
	if (m_umapGameObj.count(name) == 0) { assert(!"̖Os"); }

	SoundEngine::StopAll((AkGameObjectID)m_umapGameObj[name]);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// CXi[̍ĐCxg̒~
void CWwise::StopMainListener()
{
	CHECK_SOUND_ENGINE;
	if (m_pMainListener == nullptr) { return; }

	SoundEngine::StopAll((AkGameObjectID)m_pMainListener);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// Xe[g̐ݒ
void CWwise::SetState(int stateGroup, int stateID)
{
	CHECK_SOUND_ENGINE;

	SoundEngine::SetState(stateGroup, stateID);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// RTPC̐ݒ
void CWwise::SetGameParam(int rtpcID, float value)
{
	CHECK_SOUND_ENGINE;

	SoundEngine::SetRTPCValue(rtpcID, value);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// wwiseLv`[XgփG[bZ[W𑗂
void CWwise::PostMessage(char *szMessage)
{
	Monitor::PostString(szMessage, Monitor::ErrorLevel_Message);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// _~[R[obN
void CWwise::dummyCallback(AkCallbackType type, AkCallbackInfo *pCallbackInfo)
{
	UNREFERENCED_PARAMETER(type);
	AkEventCallbackInfo *pInfo = (AkEventCallbackInfo *)pCallbackInfo;
	AkGameObjectID id = pInfo->gameObjID;

	dummiesLock.Lock();		// bN

	// ID̗Lm߂
	auto it = std::find(dummies.begin(), dummies.end(), static_cast<int>(pInfo->playingID));
	if (it != dummies.end())
	{
		dummies.erase(it);
		AK::SoundEngine::UnregisterGameObj(id);
	}
	dummiesLock.Unlock();	// AbN
}

// ======== ======== ======== ======== ======== ======== ======== ========
// O}eAID̎擾
int CWwise::GetMaterialId(char *pName)
{
	CHECK_SOUND_ENGINE0;

	return SoundEngine::GetIDFromString(pName);
}

/*
// ======== ======== ======== ======== ======== ======== ======== ========
// Q[IuWFNgɃ}eAIDݒ
void CWwise::SetMaterial(void *gameObject, int materialid)
{
CHECK_SOUND_ENGINE;

SoundEngine::SetSwitch(SWITCHES::MATERIAL::GROUP, materialid, (AkGameObjectID)gameObject);
}
*/

// ======== ======== ======== ======== ======== ======== ======== ========
// DirectXVec3WwiseVec3ɕϊ
void CWwise::VecToAkVector(const D3DXVECTOR3 & vec, AkVector & vector)
{
	vector.X = vec.x;
	vector.Y = vec.y;
	vector.Z = vec.z;
}

/*
// ======== ======== ======== ======== ======== ======== ======== ========
// 
// XNvgR}h
// 
// -------- -------- -------- -------- -------- -------- -------- --------
// ======== ======== ======== ======== ======== ======== ======== ========
// {[ݒ (0-255)
void CWwise::musicvol(int vol)
{
	CHECK_SOUND_ENGINE;

	SoundEngine::SetRTPCValue(GAME_PARAMETERS::MUSICVOLUME, (AkRtpcValue)vol);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// SFX(GtFNg){[ݒ (0-255)
void CWwise::soundvol(int vol)
{
	CHECK_SOUND_ENGINE;

	SoundEngine::SetRTPCValue(GAME_PARAMETERS::SFXVOLUME, (AkRtpcValue)vol);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// {CX{[ݒ (0-255)
void CWwise::voicevol(int vol)
{
	CHECK_SOUND_ENGINE;

	SoundEngine::SetRTPCValue(GAME_PARAMETERS::VOICEVOLUME, (AkRtpcValue)vol);
}
*/
